% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{summary_graph_extract_components}
\alias{summary_graph_extract_components}
\title{Summarize component extraction of a graph}
\usage{
summary_graph_extract_components(
  x,
  directed = TRUE,
  bipartite_proj = FALSE,
  num_proj = 1
)
}
\arguments{
\item{x}{An igraph or a network object.}

\item{directed}{A boolean value indicating whether to create a directed graph (default = TRUE).}

\item{bipartite_proj}{A boolean value indicating whether the bipartite network should be projected (default = FALSE).}

\item{num_proj}{A number indicating the number of projects specifically for bipartite graphs (default = 1).}
}
\value{
A list of igraph objects representing the extracted components of the graph.
Each element in the list corresponds to a component, and each component is represented by an igraph object.
The components are extracted based on the connectivity of the graph and can include single nodes, disconnected subgraphs, or connected subgraphs.
If the graph is directed and the \code{directed} parameter is set to FALSE, the function returns the weakly connected components.
If the graph is bipartite and the \code{bipartite_proj} parameter is set to TRUE, the function returns the projected graph components.
If the graph is neither directed nor bipartite, the function returns the connected components.
}
\description{
This function summarizes all components of the input which can be an "igraph" object or a "network" object.
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
