% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{visualize_correlations}
\alias{visualize_correlations}
\title{Correlation plot between centrality measures}
\usage{
visualize_correlations(x, scale = TRUE, method = "pearson")
}
\arguments{
\item{x}{a list indicating calculated centrality measures}

\item{scale}{Whether the centrality values should be scaled or not(default=TRUE)}

\item{method}{a character string describing the type of correlation coefficient (or covariance)
to be computed. The proper values are "pearson", "kendall", or "spearman". (default="pearson")}
}
\value{
The function generates a correlation plot between pairs of centrality measures.
The function takes a list x as input, which contains the computed centrality measures.
If the scale parameter is set to TRUE, the centrality values will be scaled before computing the correlations.
The method parameter specifies the type of correlation coefficient to be computed: "pearson" (default), "kendall", or "spearman".
The function creates a pairwise correlation plot, where each cell represents the correlation between a pair of centrality measures.
The color of each cell indicates the strength and direction of the correlation, ranging from red (negative correlation) to blue (positive correlation).
The function returns the pairwise correlation plot.
}
\description{
This function draw correlation plot between pair of centrality measures
}
\details{
This function illustrates pairwise correlation plot of computed centrality measures.
The names of centralities shown in the result plot is abbreviated and compelete names
can be seen in "proper_centralities" function.
Colors from red to blue indicate the intensity of correlation value. If two centrality
measures have an inverse relationship then their correspnding color in plot have to be red
and vice versa.
}
\seealso{
\code{\link[GGally]{ggpairs}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
