% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uneFonction.R
\name{print.CIps}
\alias{print.CIps}
\title{Print method for the CIps class}
\usage{
\method{print}{CIps}(x, ...)
}
\arguments{
\item{x}{An object of class CIps.}

\item{...}{Additional arguments to be passed to the print function.}
}
\value{
No return value, called for its side effects, which is printing the object to the console.
}
\description{
It provides information on the selected variables, the estimated confidence intervals, and the coefficients of these selected variables.
}
\examples{
library(mlbench)
data("BostonHousing")
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50)
# CIps object
cips = CIps(model, vote = "coef", alpha = 0.05, s.vote_coef = 0.5)
# print
print(cips)

\donttest{
# lmps object
model = lmps(medv~., data = BostonHousing, method = "Lasso", N = 50, cores = 2)
# CIps object
cips = CIps(model, vote = "coef", alpha = 0.05, s.vote_coef = 0.5)
# print
print(cips)
}

}
