% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CJIVE_Functions.R
\name{sjive}
\alias{sjive}
\title{Simple JIVE}
\usage{
sjive(blocks, signal_ranks, joint.rank, joint_scores = NULL)
}
\arguments{
\item{blocks}{list of data blocks, i.e. matrices, all having the same number of rows, which correspond to the same sampling units (i.e. study participants, patients, etc.)}

\item{signal_ranks}{numerical vector of the same length as 'blocks' with each entry corresponding to the rank of the respective matrix in 'blocks'}

\item{joint.rank}{integer value corresponding to the rank of the joint signal subspace, i.e. number of components in the signal subspace}

\item{joint_scores}{numerical matrix containing joint subject scores if they were calculated by some other method, e.g. Canonical Correlation of PC scores.
Must have the same number of rows as each matrix in 'blocks' and number of columns equal to 'joint_rank'. If NULL, joint scores are calculated and
returned. Default is NULL.}
}
\value{
list of 4 or 5 items: 1) joint signal matrices, their SVDs, and the proportion of total variation in each matrix that is attributable to the joint signal
                         2) individual signal matrices, their SVDs, and the proportion of total variation in each matrix that is attributable to the individual signal
                         3) concatenated PC scores, used to determine joint subspace
                         4) projection matrix for joint subspace
                         5) joint subject scores (only returned if not provided initially)
}
\description{
Conducts AJIVE estimation under the assumption that all ranks are known and no components are discarded
}
