% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_calculate_uvl_info.R
\name{calculate_uvl_info}
\alias{calculate_uvl_info}
\title{Calculate upper verification limit}
\usage{
calculate_uvl_info(aov_return, nsamp = 1, cvr_or_sr, cvwl_or_swl)
}
\arguments{
\item{aov_return}{Return of calculate_aov_info()}

\item{nsamp}{number of samples in the experiment}

\item{cvr_or_sr}{Desirable CV or S repetability}

\item{cvwl_or_swl}{Desirable CV or S within-lab}
}
\value{
Named list with UVL params
}
\description{
Generic function for calculating UVL the return is a named list and cv_uvl_r and cv_uvl_wl depends on what is the input (S or CV) if the input is SR and SWL the returns is S
}
\examples{
 data <- create_table_ep_15(ferritin_wider)
 aov_t <- calculate_aov_infos(data)
 calculate_uvl_info(aov_t, nsamp = 5, cvr_or_sr = .43, cvwl_or_swl = .7)
}
