% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/f_s3generics_clvdata.R
\name{as.clv.data}
\alias{as.clv.data}
\alias{as.clv.data.data.frame}
\alias{as.clv.data.data.table}
\title{Coerce to clv.data object}
\usage{
as.clv.data(
  x,
  date.format = "ymd",
  time.unit = "weeks",
  estimation.split = NULL,
  data.end = NULL,
  name.id = "Id",
  name.date = "Date",
  name.price = "Price",
  ...
)

\method{as.clv.data}{data.frame}(
  x,
  date.format = "ymd",
  time.unit = "weeks",
  estimation.split = NULL,
  data.end = NULL,
  name.id = "Id",
  name.date = "Date",
  name.price = "Price",
  ...
)

\method{as.clv.data}{data.table}(
  x,
  date.format = "ymd",
  time.unit = "weeks",
  estimation.split = NULL,
  data.end = NULL,
  name.id = "Id",
  name.date = "Date",
  name.price = "Price",
  ...
)
}
\arguments{
\item{x}{Transaction data.}

\item{date.format}{Character string that indicates the format of the date variable in the data used. See details.}

\item{time.unit}{What time unit defines a period. May be abbreviated, capitalization is ignored. See details.}

\item{estimation.split}{Indicates the length of the estimation period. See details.}

\item{data.end}{The fictional end of the data, after the last recorded transaction in \code{x}. See details.}

\item{name.id}{Column name of the customer id in \code{x}.}

\item{name.date}{Column name of the transaction date in \code{x}.}

\item{name.price}{Column name of price in \code{x}. NULL if no spending data is present.}

\item{...}{Ignored}
}
\description{
Functions to coerce transaction data to a \code{clv.data} object.
}
\details{
See section "Details" of \link{clvdata} for more details on parameters and usage.
}
\examples{
\donttest{ # dont test because ncpu=2 limit on cran (too fast)
data(cdnow)

# Turn data.table of transaction data into a clv.data object,
#  using default date format and column names but no holdout period
clv.cdnow <- as.clv.data(cdnow)
}

}
