% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bgnbd_LL}
\alias{bgnbd_LL}
\alias{bgnbd_nocov_LL_ind}
\alias{bgnbd_nocov_LL_sum}
\alias{bgnbd_staticcov_LL_ind}
\alias{bgnbd_staticcov_LL_sum}
\title{BG/NBD: Log-Likelihood functions}
\usage{
bgnbd_nocov_LL_ind(vLogparams, vX, vT_x, vT_cal)

bgnbd_nocov_LL_sum(vLogparams, vX, vT_x, vT_cal, vN)

bgnbd_staticcov_LL_ind(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)

bgnbd_staticcov_LL_sum(vParams, vX, vT_x, vT_cal, vN, mCov_life, mCov_trans)
}
\arguments{
\item{vLogparams}{vector with the BG/NBD model parameters at log scale. See Details.}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vN}{The value ("number of times observed") with which the LL value of this observation is multiplied before summing across customers.}

\item{vParams}{vector with the parameters for the BG/NBD model at log scale and the static covariates at original scale. See Details.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\value{
Returns the respective Log-Likelihood value(s) for the BG/NBD model
 with or without covariates.
}
\description{
Calculates the Log-Likelihood values for the BG/NBD model with and without covariates.

The function \code{bgnbd_nocov_LL_ind} calculates the individual log-likelihood
values for each customer for the given parameters.

The function \code{bgnbd_nocov_LL_sum} calculates the log-likelihood value summed
across customers for the given parameters.

The function \code{bgnbd_staticcov_LL_ind} calculates the individual log-likelihood
values for each customer for the given parameters and covariates.

The function \code{bgnbd_staticcov_LL_sum} calculates the individual log-likelihood values summed
across customers.
}
\details{
\code{vLogparams} is a vector with model parameters \code{r, alpha_0, a, b} at log-scale, in this order.

\code{vParams} is vector with the BG/NBD model parameters at log scale,
followed by the parameters for the lifetime covariates at original scale and then
followed by the parameters for the transaction covariates at original scale

\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vLogparams} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vLogparams} at the respective position.
}
\references{
Fader PS, Hardie BGS, Lee KL (2005). \dQuote{\dQuote{Counting Your Customers} the Easy Way:
An Alternative to the Pareto/NBD Model} Marketing Science, 24(2), 275-284.

Fader PS, Hardie BGS (2013). \dQuote{Overcoming the BG/NBD Model's #NUM! Error Problem}
URL \url{http://brucehardie.com/notes/027/bgnbd_num_error.pdf}.

Fader PS, Hardie BGS (2007). \dQuote{Incorporating time-invariant covariates into the
Pareto/NBD and BG/NBD models.}
URL \url{http://www.brucehardie.com/notes/019/time_invariant_covariates.pdf}.

Fader PS, Hardie BGS, Lee KL (2007). \dQuote{Creating a Fit Histogram for the BG/NBD Model}
URL \url{https://www.brucehardie.com/notes/014/bgnbd_fit_histogram.pdf}
}
