% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinflateFac.R
\name{reinflateFac}
\alias{reinflateFac}
\title{Reinflate all datablocks from a model Fac object.}
\usage{
reinflateFac(Fac, Z, returnAsTensor = FALSE)
}
\arguments{
\item{Fac}{Fac object output from CMTF and ACMTF}

\item{Z}{Z object as generated by \code{\link[=setupCMTFdata]{setupCMTFdata()}}.}

\item{returnAsTensor}{Boolean to return data blocks as rTensor tensor objects (default FALSE)}
}
\value{
List of data blocks
}
\description{
Basically a wrapper function for \code{\link[=reinflateTensor]{reinflateTensor()}} and \code{\link[=reinflateMatrix]{reinflateMatrix()}}.
}
\examples{
set.seed(123)
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
D = array(rnorm(100*2), c(100,2))
E = array(rnorm(10*2), c(10,2))

df1 = reinflateTensor(A, B, C)
df2 = reinflateTensor(A, D, E)
datasets = list(df1, df2)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes, normalize=FALSE)

result = cmtf_opt(Z, 1, max_iter=2)
Xhats = reinflateFac(result$Fac, Z)
}
