% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{diff_abund}
\alias{diff_abund}
\title{Calculate features with different abundances between treatment groups}
\usage{
diff_abund(model_out, countData, prob_threshold = 0.05)
}
\arguments{
\item{model_out}{Output of CNVRG modeling functions, including cnvrg_HMC and cnvrg_VI}

\item{countData}{Dataframe of count data that was modeled. Should be exactly the same as those data modeled! The first field should be sample name and integer count data should be in all other fields. This is passed in so that the names of fields can be used to make the output of differential relative abundance testing more readable.}

\item{prob_threshold}{Probability threshold, below which it is considered that features had a high probability of differing between groups. Default is 0.05.}
}
\value{
A dataframe with the first field denoting the treatment comparison (e.g., treatment 1 vs. 2) and subsequent fields stating the proportion of samples from the posterior that were greater than zero (called "certainty of diffs"). Note that each treatment group is compared to all other groups, which leads to some redundancy in output. A list, called ppd_diffs, holding samples from the posterior probability distribution of the differences is also output. Finally, a list of dataframes describing results for only those features with a high probability of differing is output (this list is named: features_that_differed).
}
\description{
This function determines which features within the matrix that was modeled differ in relative abundance among treatment groups.
Pass in a model object, with samples for pi parameters.
This function only works for pi parameters.
}
\details{
The output of this function gives the proportion of samples that were greater than zero after subtracting the two relevant posterior distributions. Therefore, values that are very large or very small denote a high certainty that the distributions subtracted differ.
If this concept is not clear, then read Harrison et al. 2020 'Dirichlet multinomial modeling outperforms alternatives for analysis of microbiome and other ecological count data' in Molecular Ecology Resources.
For a simple explanation, see this video: https://use.vg/OSVhFJ

The posterior probability distribution of differences is also output. These samples can be useful for plotting or other downstream analyses.
Finally, a list of data frames describing the features that differed among treatment comparisons is output, with the probability of differences and the magnitude of those differences (the effect size) included.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

out <- cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
diff_abund_test <- diff_abund(model_out = out, countData = com_demo)
}
