% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{extract_point_estimate}
\alias{extract_point_estimate}
\title{Extract point estimates of multinomial and Dirichlet parameters}
\usage{
extract_point_estimate(model_out, countData, params = c("pi", "p"))
}
\arguments{
\item{model_out}{Output of CNVRG modeling functions, including cnvrg_HMC and cnvrg_VI}

\item{countData}{The count data modeled.}

\item{params}{Parameters to be extracted, either pi (Dirichlet) or p (multinomial).}
}
\value{
A list of of point estimates for model parameters. If both multinomial and Dirichlet parameters are requested then they will be named elements of a list.
}
\description{
Provides the mean value of posterior probability distributions for parameters.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

out <- cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
extract_point_estimate(model_out = out, countData = com_demo)
}
