% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{isd_transform}
\alias{isd_transform}
\title{Transform data into estimates of absolute abundances using an ISD}
\usage{
isd_transform(model_out, isd_index, countData, format = "stan")
}
\arguments{
\item{model_out}{Output of CNVRG modeling functions, including cnvrg_HMC and cnvrg_VI}

\item{isd_index}{The index for the field with information for the internal standard.}

\item{countData}{The count data modeled.}

\item{format}{The output format. Can be either 'or 'samples' or 'ml'. "samples" outputs samples from the posterior probability distribution, the last option ("ml") outputs the mean of posterior samples for each parameter.}
}
\value{
A dataframe, or list, specifying either point estimates for each feature in each treatment group (if output format is 'ml') or samples from the posterior (if output format is 'samples').
}
\description{
If an internal standard (ISD) has been added to samples such that the counts for that standard are representative of the same absolute abundance, then the ISD can be used to transform relative abundance data such that they are proportional to absolute abundances (Harrison et al. 2020).
This function performs this division while preserving uncertainty in relative abundance estimates of both the ISD and the other features present.
}
\details{
An index for the ISD must be provided. This should be the field index that corresponds with the ISD. Remember that the index should mirror what has been modeled. Also, note that this function subtracts one from this index because the modeled data have a non integer sample field.
If the wrong index is passed in, the output of this function will be incorrect, but there will not be a fatal error or warning.

A simple check that the correct index has been passed to the function is to examine the output and make sure that the field that should correspond with the ISD is one (signifying that the ISD was divided by itself).

Output format can either as means of the samples for each pi parameter or the transformed samples from the posterior distribution for that parameter.
Harrison et al. 2020. 'The quest for absolute abundance: the use of internal standards for DNA based community ecology' Molecular Ecology Resources.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

#Model the data
out <- cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
#Transform the data
transformed_data <- isd_transform(model_out = out, countData = com_demo,
isd_index = 3, format = "ml")
}
