% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_loglik_2stage.R
\name{naive_loglik_2stage}
\alias{naive_loglik_2stage}
\title{Observed Data Log-Likelihood Function for Estimation of the Naive Two-Stage Misclassification Model}
\usage{
naive_loglik_2stage(
  param_current,
  X,
  V,
  obs_Ystar_matrix,
  obs_Ytilde_matrix,
  sample_size,
  n_cat
)
}
\arguments{
\item{param_current}{A numeric vector of regression parameters, in the order
\eqn{\beta, \delta}. The \eqn{\delta} vector is obtained from the matrix form.
In matrix form, the gamma parameter matrix rows
correspond to parameters for the \eqn{\tilde{Y} = 1}
observed outcome, with the dimensions of \code{V}.
In matrix form, the gamma parameter matrix columns correspond to the true outcome categories
\eqn{j = 1, \dots,} \code{n_cat}. The numeric vector \code{delta_v} is
obtained by concatenating the delta matrix, i.e. \code{delta_v <- c(delta_matrix)}.}

\item{X}{A numeric design matrix for the first-stage observed mechanism.}

\item{V}{A numeric design matrix for the second-stage observed mechanism.}

\item{obs_Ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the first-stage observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{obs_Ytilde_matrix}{A numeric matrix of indicator variables (0, 1) for the second-stage observed
outcome \eqn{\tilde{Y}}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{sample_size}{Integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X} or \code{V}.}

\item{n_cat}{The number of categorical values that the first- and second-stage outcomes,
\eqn{Y^*} and \eqn{\tilde{Y}}, can take.}
}
\value{
\code{naive_loglik_2stage} returns the negative value of the observed data log-likelihood function,
\eqn{ \sum_{i = 1}^N \Bigl[ \sum_{k = 1}^2 \sum_{k = 1}^2 \sum_{\ell = 1}^2 y^*_{ik} \tilde{y_i} \text{log} \{ P(\tilde{Y}_{i} = \ell, Y^*_i = k | x_i, v_i) \}\Bigr]},
at the provided inputs.
}
\description{
Observed Data Log-Likelihood Function for Estimation of the Naive Two-Stage Misclassification Model
}
