% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmp-reg.R
\name{glm.cmp, CMP support}
\alias{glm.cmp, CMP support}
\alias{summary.cmpfit}
\alias{print.cmpfit}
\alias{logLik.cmpfit}
\alias{AIC.cmpfit}
\alias{BIC.cmpfit}
\alias{coef.cmpfit}
\alias{nu.cmpfit}
\alias{sdev.cmpfit}
\alias{vcov.cmpfit}
\alias{equitest.cmpfit}
\alias{leverage.cmpfit}
\alias{deviance.cmpfit}
\alias{residuals.cmpfit}
\alias{predict.cmpfit}
\alias{parametric.bootstrap.cmpfit}
\title{Supporting Functions for COM-Poisson Regression}
\usage{
\method{summary}{cmpfit}(object, ...)

\method{print}{cmpfit}(x, ...)

\method{logLik}{cmpfit}(object, ...)

\method{AIC}{cmpfit}(object, ..., k = 2)

\method{BIC}{cmpfit}(object, ...)

\method{coef}{cmpfit}(object, type = c("vector", "list"), ...)

\method{nu}{cmpfit}(object, ...)

\method{sdev}{cmpfit}(object, type = c("vector", "list"), ...)

\method{vcov}{cmpfit}(object, ...)

\method{equitest}{cmpfit}(object, ...)

\method{leverage}{cmpfit}(object, ...)

\method{deviance}{cmpfit}(object, ...)

\method{residuals}{cmpfit}(object, type = c("raw", "quantile"), ...)

\method{predict}{cmpfit}(object, newdata = NULL, type = c("response", "link"), ...)

\method{parametric.bootstrap}{cmpfit}(object, reps = 1000, report.period = reps + 1, ...)
}
\arguments{
\item{object}{object of type \code{cmp}.}

\item{...}{other arguments, such as \code{subset} and \code{na.action}.}

\item{x}{object of type \code{cmp}.}

\item{k}{Penalty per parameter to be used in AIC calculation.}

\item{type}{Specifies quantity to be computed. See details.}

\item{newdata}{New covariates to be used for prediction.}

\item{reps}{Number of bootstrap repetitions.}

\item{report.period}{Report progress every \code{report.period} iterations.}
}
\description{
Supporting Functions for COM-Poisson Regression
}
\details{
The function \code{residuals} returns raw residuals when
\code{type = "raw"}  and quantile residuals when
\code{type = "quantile"}.

The function \code{predict} returns expected values of the outcomes,
eveluated at the computed estimates, when \code{type = "response"}. When
\code{type = "link"}, a \code{data.frame} is instead returned with
columns corresponding to estimates of \code{lambda} and \code{nu}.

The function \code{coef} returns a vector of coefficient estimates in
the form \code{c(beta, gamma)} when \code{type = "vector"}. When
\code{type = "list"}, the estimates are returned as a list with named
elements \code{beta} and \code{gamma}.

The \code{type} argument behaves the same for the \code{sdev} function
as it does for \code{coef}.
}
