% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{get_lrv_vec}
\alias{get_lrv_vec}
\title{Long-Run Variance Estimation With Possible Change Points}
\usage{
get_lrv_vec(dat, kernel = "ba", bandwidth = "and")
}
\arguments{
\item{dat}{The data vector}

\item{kernel}{If character, the identifier of the kernel function as used in
\pkg{cointReg} (see \code{\link[cointReg]{getLongRunVar}}); if
function, the kernel function to be used for long-run variance
estimation (default is the Bartlett kernel in \pkg{cointReg})}

\item{bandwidth}{If character, the identifier for how to compute the
bandwidth as defined in \pkg{cointReg} (see
\code{\link[cointReg]{getBandwidth}}); if function, a function
to use for computing the bandwidth; if numeric, the bandwidth
value to use (the default is to use Andrews' method, as used in
\pkg{cointReg})}
}
\value{
A vector of estimates of the long-run variance
}
\description{
Computes the estimates of the long-run variance in a change point context, as
described in \insertCite{horvathricemiller19}{CPAT}. By default it uses
kernel and bandwidth selection as used in the package \pkg{cointReg}, though
changing the parameters \code{kernel} and \code{bandwidth} can change this
behavior. If \pkg{cointReg} is not installed, the Bartlett internal (defined
internally) will be used and the bandwidth will be the square root of the
sample size.
}
\examples{
x <- rnorm(1000)
CPAT:::get_lrv_vec(x)
CPAT:::get_lrv_vec(x, kernel = "pa", bandwidth = "nw")
}
\references{
\insertAllCited{}
}
