% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summarize.cpsurv}
\alias{summarize.cpsurv}
\alias{print.cpsurv}
\alias{summary.cpsurv}
\alias{print.summary.cpsurv}
\title{Summarize and print cpsurv objects}
\usage{
\method{print}{cpsurv}(x, ...)

\method{summary}{cpsurv}(object, ...)

\method{print}{summary.cpsurv}(x, ...)
}
\arguments{
\item{x}{An object of class \code{cpsurv} or \code{summary.cpsurv} to be
printed out.}

\item{...}{not used}

\item{object}{An object of class \code{cpsurv}.}
}
\description{
Summary and print methods for objects inheriting from a call to
  \code{\link{cpsurv}}.
}
\details{
The main results from \code{cpsurv} are printed out in a
  well-arranged format. If the estimated change point is bias corrected, both
  estimates (the original, and the corrected one) are shown in the summary.
  If a bootstrap-sampling was executed, the output contains a summary of the
  resultant bootstrap-estimates.
}
\examples{
data(survdata)
cpest <- cpsurv(survdata$time, survdata$event, cpmax = 360)
summary(cpest)
}
\seealso{
\code{\link{cpsurv}}
}
