% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSMES.predictPareto.R
\name{CSMES.predictPareto}
\alias{CSMES.predictPareto}
\title{Generate predictions for all Pareto-optimal ensemble classifier candidates selected through CSMES}
\usage{
CSMES.predictPareto(ensSelModel, newdata)
}
\arguments{
\item{ensSelModel}{ensemble selection model (output of \code{CSMES.ensSel})}

\item{newdata}{data.frame or matrix containing data to be scored}
}
\value{
An object of the class \code{CSMES.predictPareto} which is a list with the following two components:
\item{Pareto_predictions_c}{A vector with class predictions.}
\item{Paret_predictions_p}{A vector with probability predictions.}
}
\description{
This function generates predictions for all pareto-optimal ensemble classifier candidates as identified through the first training stage of CSMES (\code{CSMES.ensSel}).
}
\examples{
##load data
library(rpart)
library(zoo)
library(ROCR)
library(mco)
data(BFP)
##generate random order vector
BFP_r<-BFP[sample(nrow(BFP),nrow(BFP)),]
size<-nrow(BFP_r)
##size<-300
train<-BFP_r[1:floor(size/3),]
val<-BFP_r[ceiling(size/3):floor(2*size/3),]
test<-BFP_r[ceiling(2*size/3):size,]
##generate a list containing model specifications for 100 CART decisions trees varying in the cp
##and minsplit parameters, and trained on bootstrap samples (bagging)
rpartSpecs<-list()
for (i in 1:100){
  data<-train[sample(1:ncol(train),size=ncol(train),replace=TRUE),]
  str<-paste("rpartSpecs$rpart",i,"=rpart(as.formula(Class~.),data,method=\"class\",
  control=rpart.control(minsplit=",round(runif(1, min = 1, max = 20)),",cp=",runif(1,
  min = 0.05, max = 0.4),"))",sep="")
  eval(parse(text=str))
}
##generate predictions for these models
hillclimb<-mat.or.vec(nrow(val),100)
for (i in 1:100){
  str<-paste("hillclimb[,",i,"]=predict(rpartSpecs[[i]],newdata=val)[,2]",sep="")
  eval(parse(text=str))
}
##score the validation set used for ensemble selection, to be used for ensemble selection
ESmodel<-CSMES.ensSel(hillclimb,val$Class,obj1="FNR",obj2="FPR",selType="selection",
generations=10,popsize=12,plot=TRUE)
## Create Ensemble nomination curve
enc<-CSMES.ensNomCurve(ESmodel,hillclimb,val$Class,curveType="costCurve",method="classPreds",
plot=FALSE)
}
\references{
De Bock, K.W., Lessmann, S. And Coussement, K., Cost-sensitive business failure prediction
when misclassification costs are uncertain: A heterogeneous ensemble selection approach,
European Journal of Operational Research (2020), doi: 10.1016/j.ejor.2020.01.052.
}
\seealso{
\code{\link{CSMES.ensSel}}, \code{\link{CSMES.predict}}, \code{\link{CSMES.ensNomCurve}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
