% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{CSeQTL_oneExtremeSim}
\alias{CSeQTL_oneExtremeSim}
\title{CSeQTL_oneExtremeSim}
\usage{
CSeQTL_oneExtremeSim(
  NN,
  MAF,
  true_BETA0,
  true_KAPPA,
  true_ETA,
  true_PHI = 0.1,
  wRHO,
  noiseRHO = 0,
  RR = 50,
  vec_MARG = c(TRUE, FALSE),
  vec_TRIM = c(TRUE, FALSE),
  vec_PERM = c(TRUE, FALSE),
  thres_TRIM = 10,
  ncores = 1,
  sim_fn
)
}
\arguments{
\item{NN}{Positive integer for sample size.}

\item{MAF}{Positive numeric value between 0 and 1 for the minor 
allele frequency to simulate phased SNP genotypes assuming Hardy-Weinberg.}

\item{true_BETA0}{A positive numeric value denoting the reference cell type
and reference base's expression multiplied by two and log transformed.
For example, if the TReC for reference base and cell type is 500, then
\code{true_BETA0 = log{2 * 500}}.}

\item{true_KAPPA}{A numeric vector denoting the baseline fold change in TReC
between a cell type and reference. By definition, the first element is 1.}

\item{true_ETA}{A numeric vector where each element denotes the fold change 
in TReC between the non-reference and reference base in a cell type.}

\item{true_PHI}{A non-negative numeric value denoting the over-dispersion term
associated with TReC. If \code{true_PHI > 0}, TReC is simulated with the 
negative binomial. If \code{true_PHI = 0}, TReC is simulated with the poisson.}

\item{wRHO}{Takes integer values 1, 2, or 3 to simulate three 
scenarios of cell type proportions.}

\item{noiseRHO}{A positive numeric value to purposely distort simulated 
cell type compositions.}

\item{RR}{A positive integer for number of replicates to generate and analyze.}

\item{vec_MARG}{A boolean vector for marginal and/or cell type-specific
analyses to be run. By default, both sets of analyses are run.}

\item{vec_TRIM}{A boolean vector for whether or not analyses with 
trimmed outcomes are included. By default, both sets of analyses are run.}

\item{vec_PERM}{A boolean vector for whether or not permuted SNP analyses
are included. By default, both sets of analyses are run.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{ncores}{A positive integer specifying the number of threads available
to decrease computational runtime.}

\item{sim_fn}{Character value specifying the full path and filename
to store intermediate simulation replicates should errors arise.}
}
\value{
A R list containing the results of a small-scale simulation.
\code{res} contains replicate-specific results while \code{ures} contains
overall simulation results include power, frequency of replicates with 
constrained eta estimates and gene expressions inferred to be zero after optimization.
}
\description{
Performs a simulation with multiple replicates
for a pre-specified set of arguments.
}
