% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_tracking.R
\name{snapshot_packages}
\alias{snapshot_packages}
\title{Track Package Versions and Dependencies}
\usage{
snapshot_packages(
  output_file = NULL,
  include_dependencies = TRUE,
  only_attached = FALSE
)
}
\arguments{
\item{output_file}{Character. Path to save package info. If NULL, returns as list.}

\item{include_dependencies}{Logical. Include dependency tree. Default TRUE.}

\item{only_attached}{Logical. Only track attached packages. Default FALSE.}
}
\value{
A list containing package information
}
\description{
Creates a comprehensive snapshot of all installed packages, their versions,
dependencies, and sources for reproducibility.
}
\examples{
\dontrun{
# Track all installed packages
snapshot_packages("package_manifest.json")

# Track only attached packages
snapshot_packages("packages.json", only_attached = TRUE)
}
}
