% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{hfPrevention_mtc_network}
\alias{hfPrevention_mtc_network}
\title{Statins for Heart Failure Prevention}
\format{
An 'mtc.network' object (list) with 4 components:
\describe{
  \item{description}{Character string describing the analysis: "Cholesterol lowering in HF (outcome: death)"}
  \item{treatments}{Data frame with 2 treatments:
    \describe{
      \item{id}{Treatment ID (factor with 2 levels)}
      \item{description}{Treatment description (character vector)}
    }
  }
  \item{data.ab}{Data frame with 38 rows (arm-level data):
    \describe{
      \item{study}{Study ID (factor with 19 levels)}
      \item{treatment}{Treatment assignment (factor with 2 levels)}
      \item{responders}{Number of deaths (integer vector)}
      \item{sampleSize}{Total sample size per arm (integer vector)}
    }
  }
  \item{studies}{Data frame with 19 rows (study-level data):
    \describe{
      \item{study}{Study ID (factor with 19 levels)}
      \item{secondary}{Prevention type: 0 = primary, 1 = secondary (integer vector)}
    }
  }
}
}
\source{
Data taken from the gemtc package version 1.0-2. Original publication:
Dias S, Sutton AJ, Welton NJ, Ades AE (2013).
"Heterogeneity - Subgroups, Meta-Regression, Bias, and Bias-Adjustment."
Medical Decision Making, 33(5):618-640.
}
\usage{
data(hfPrevention_mtc_network)
}
\description{
This dataset, hfPrevention_mtc_network, contains network meta-analysis data from 19 trials
comparing statins versus placebo or usual care for cholesterol lowering in heart failure.
The main outcome measured is the number of deaths. Trials are categorized as either
primary prevention (no previous heart disease) or secondary prevention (previous heart disease).
}
\details{
The dataset name has been kept as 'hfPrevention_mtc_network' to maintain consistency with
its original source and to avoid confusion with other datasets. This naming convention helps
identify this specific network meta-analysis dataset from the CardioDataSets package.
The dataset is structured as an 'mtc.network' object, which is the standard format for
network meta-analysis in the gemtc package. The original content has not been modified.
}
