% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_npmetric_erf.R
\name{estimate_npmetric_erf}
\alias{estimate_npmetric_erf}
\title{Estimate smoothed exposure-response function (ERF) for pseudo population}
\usage{
estimate_npmetric_erf(
  m_Y,
  m_w,
  counter_weight,
  bw_seq,
  w_vals,
  nthread,
  kernel_appr = "locpol"
)
}
\arguments{
\item{m_Y}{A vector of outcome variable in the matched set.}

\item{m_w}{A vector of continuous exposure variable in the matched set.}

\item{counter_weight}{A vector of counter or weight variable in the matched
set.}

\item{bw_seq}{A vector of bandwidth values.}

\item{w_vals}{A vector of values that you want to calculate the values of
the ERF at.}

\item{nthread}{The number of available cores.}

\item{kernel_appr}{Internal kernel approach. Available options are \code{locpol}
and \code{kernsmooth}.}
}
\value{
The function returns a gpsm_erf object. The object includes the following
attributes:
\itemize{
\item params
\item m_Y
\item m_w
\item bw_seq
\item w_vals
\item erf
\item fcall
}
}
\description{
Estimate smoothed exposure-response function (ERF) for matched and weighted
data set using non-parametric models.
}
\details{
Estimate Functions Using Local Polynomial kernel regression.
}
\keyword{internal}
