% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameter_matrix.R
\name{set_parameter_matrix}
\alias{set_parameter_matrix}
\title{Set parameter matrix}
\usage{
set_parameter_matrix(model, P = NULL)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be
provided to avoid repeated computation for simulations. See \code{inspect(model, "parameter_matrix")}.}
}
\value{
An object of class \code{causal_model}. It essentially returns a
  list containing the elements comprising a model
  (e.g. 'statement', 'nodal_types' and 'DAG') with the parameter matrix
  attached to it.
}
\description{
Add a parameter matrix to a model
}
\examples{
model <- make_model('X -> Y')
P <- diag(8)
colnames(P) <- inspect(model, "causal_types") |> rownames()
model <- set_parameter_matrix(model, P = P)
}
\keyword{internal}
