% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.r
\name{NlmeJobStatus}
\alias{NlmeJobStatus}
\title{Reads progress file and returns the status of a job}
\usage{
NlmeJobStatus(job)
}
\arguments{
\item{job}{NLME job object}
}
\value{
Character. Job status messages.
}
\description{
Reads progress file and returns the status of a job
}
\examples{
\dontrun{
  model <- pkmodel(
    parameterization = "Clearance",
    numCompartments = 2,
    data = pkData,
    ID = "Subject",
    Time = "Act_Time",
    A1 = "Amount",
    CObs = "Conc",
    workingDir = tempdir()
  )

  params <- NlmeEngineExtraParams(
    method = 3,
    numIterations = 1
  )

  host <- hostParams(
    sharedDirectory = tempdir(),
    parallelMethod = "LOCAL_MPI",
    hostName = "local_mpi",
    numCores = 4
  )

  profile1 <- ProfileVar(
    "tvV",
    9.548,
    "-2,0"
  )

  profile2 <- ProfileVar(
    "tvCl",
    0.919,
    "-0.5,0"
  )

  profiles <- ProfileParameters(
    "USE_DELTA",
    c(profile1, profile2)
  )

  job <- profilePertubate(
    hostPlatform = host,
    params = params,
    profiles = profiles,
    model = model
  )

  status <- NlmeJobStatus(job)
}

}
\keyword{internal}
