% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyModel.R
\name{copyModel}
\alias{copyModel}
\title{Copy model object to iterate over base model}
\usage{
copyModel(model, acceptAllEffects = FALSE, modelName = "", workingDir = "")
}
\arguments{
\item{model}{Model object to be copied}

\item{acceptAllEffects}{Set to \code{TRUE} to accept all effects, update PML statements, and test.mdl file from original model run}

\item{modelName}{New model name for subdirectory created for model output. Subdirectory is created in current working directory.}

\item{workingDir}{Working directory to run the model. Current working directory will be used if workingDir not specified.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Copies previously executed model into a new object and optionally accept all estimates returned from model execution.
A new working directory is created and all files from base model are copied into it.
}
\examples{
\dontrun{
model <- pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
  )
 host <- hostParams(sharedDirectory = tempdir(),
                    parallelMethod = "None",
                    hostName = "local",
                    numCores = 1)
job <- fitmodel(model,
                numIterations = 3,
                hostPlatform = host)

finalModelVPC <- copyModel(model,
                           acceptAllEffects = TRUE,
                           modelName = "model_VPC",
                           workingDir = tempdir())
}

}
