% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.r
\name{simmodel}
\alias{simmodel}
\title{Executes an NLME simulation}
\usage{
simmodel(
  model,
  simParams,
  params,
  hostPlatform = NULL,
  runInBackground = FALSE,
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{simParams}{Simulation parameters. See \code{\link{NlmeSimulationParams}}.
If \code{missing}, default parameters generated by NlmeSimulationParams() are used.}

\item{params}{Engine parameters. See \code{\link{engineParams}}. The common
parameters include: sort, ODE, rtolODE, atolODE, maxStepsODE.
If \code{missing}, default parameters generated by engineParams(model) are used.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, simple local host is used.}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{...}{Additional class initializer arguments for \code{\link{NlmeSimulationParams}}, or
arguments available inside \code{\link{hostParams}} or \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both \code{hostPlatform}
 argument and additional argument, then its slots will be overridden by additional arguments.
 In addition, if \code{\link{NlmeSimulationParams}} arguments are supplied through both
 \code{simParams} argument and additional argument,
 then its slots will be overridden by additional arguments.}
}
\value{
returns job properties if runInBackground is \code{TRUE};
if runInBackground is \code{FALSE} and the function is called in interactive mode,
the resulted simulated tables wil be loaded and presented as a list;
if runInBackground is \code{FALSE} and the function is called in non-interactive mode,
the list returned will have just the full paths of the tables generated.
}
\description{
Executes an NLME simulation
}
\examples{
\dontrun{
SimTableObs <- tableParams(
  name = "SimTableObs.csv",
  timesList = "0,1,2,4,4.9,55.1,56,57,59,60",
  variablesList = "C, CObs",
  timeAfterDose = FALSE,
  forSimulation = TRUE
)

simParams <- NlmeSimulationParams(
  numReplicates = 2,
  simulationTables = SimTableObs
)
# Define the model
model <- pkmodel(
  numComp = 2,
  absorption = "Extravascular",
  ID = "Subject",
  Time = "Act_Time",
  CObs = "Conc",
  Aa = "Amount",
  data = pkData,
  modelName = "PkModel",
  workingDir = tempdir()
)

host <- hostParams(
  sharedDirectory = tempdir(),
  parallelMethod = "NONE",
  hostName = "local",
  numCores = 1
 )

results <- simmodel(model, simParams, hostPlatform = host)
# with seed given additionally:
results <- simmodel(model, simParams, hostPlatform = host, seed = 3527)
}
}
