.create_overallDF <- function(dmp.txt, method, problem = 1) {
  # calculate condition number
  Condition <- NA
  if (!is.null(dmp.txt$varFix)) {
    nThetaVarCovar <- ncol(dmp.txt$varFix) - ncol(dmp.txt$sigma)
    stopifnot(nThetaVarCovar > 0)
    thetaVarCovar <- dmp.txt$varFix[1:nThetaVarCovar, 1:nThetaVarCovar]
    thetaEigensOverall <- eigen(thetaVarCovar, symmetric = TRUE, only.values = TRUE)
    thetaEigens <- sort(thetaEigensOverall$values)
    positiveThetaEigens <- thetaEigens[which(thetaEigens > 0)]
    if (length(thetaEigens) > 0) {
      Condition <- sqrt(positiveThetaEigens[length(thetaEigens)] / positiveThetaEigens[1])
    }
  }

  overall <-
    tibble::tibble(
      RetCode = dmp.txt$returnCode,
      logLik = dmp.txt$logLik,
      `-2LL` = -2 * dmp.txt$logLik,
      AIC = -2 * dmp.txt$logLik + dmp.txt$nParm * 2,
      BIC = -2 * dmp.txt$logLik + dmp.txt$nParm * log(dmp.txt$nObs),
      nParm = dmp.txt$nParm,
      nObs = dmp.txt$nObs,
      nSub = dmp.txt$nSubj,
      Condition = Condition
    )

  overallDF <- tibble::tibble(
    name = "Overall",
    extension = "csv",
    problem = problem,
    subprob = 0,
    method = method,
    data = list(overall),
    modified = FALSE
  )

  overallDF
}
