% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xposeNlmeModel.R
\name{xposeNlmeModel}
\alias{xposeNlmeModel}
\title{Creates xpose database from Certara.RsNLME objects}
\usage{
xposeNlmeModel(model, fitmodelOutput)
}
\arguments{
\item{model}{NlmePmlModel model class object generated by \code{Certara.RsNLME}
package}

\item{fitmodelOutput}{the output object of \code{Certara.RsNLME::fitmodel()} run.}
}
\value{
\code{xpdb} object
}
\description{
Imports results of an NLME run into xpose database
Use to import NLME model object and NLME object output
into \code{xpdb} object that is compatible
with existing model diagnostic function in \code{Xpose} package.
}
\details{
Not all functionality from the \code{xpose} package is supported.
}
\examples{
\donttest{
library(Certara.RsNLME)
library(Certara.Xpose.NLME)

model <- pkmodel(
  parameterization = "Clearance",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc"
)

fit <- fitmodel(model)

xp <- xposeNlmeModel(
  model = model,
  fitmodelOutput = fit
)
}
}
