test_that("xpose used for covariate distribution  ", {
  workingDir <- system.file("extdata/cov_distrib",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )
  modelName <- "covmodel"
  dmp.json <- paste0(modelName, "_dmp.json")
  dmp.txt <- jsonlite::fromJSON(readLines(file.path(workingDir, dmp.json)))

  residuals.csv <- paste0(modelName, "_residuals.csv")
  dmp.txt$residuals <- utils::read.csv(file.path(workingDir, residuals.csv))

  dataFile <- paste0("data1.csv")

  logFile <- paste0(modelName, "_nlme7engine.log")

  xpdb <- xposeNlme(
    dir = workingDir,
    dmp.txt = dmp.txt,
    dataFile = dataFile,
    logFile = logFile
  )

  testthat::local_edition(3)
  testthat::expect_snapshot(as.data.frame(xpdb$data$index[[1]]))

  testthat::skip_on_os("linux")
  TempDir <- tempdir(TRUE)
  ext <- "png"
  CovariatesToCheck <- c("sex", "wt")
  pdf(NULL)
  # _vs_cov family
  for (prefixFunc in c("res", "prm", "eta")) {
    for (covar in CovariatesToCheck) {
      fileName <- paste(.Platform$OS.type, prefixFunc, "vs_cov", covar, sep = "_")
      fileWithPath <- file.path(TempDir, paste(fileName, ext, sep = "."))
      if (file.exists(fileWithPath)) {
        file.remove(fileWithPath)
      }

      suppressWarnings(plotGenerated <-
        do.call(
          what = paste0(prefixFunc, "_vs_cov"),
          args = list(
            xpdb = xpdb,
            covariate = covar,
            caption = "test"
          )
        ))

      suppressWarnings(
        ggplot2::ggsave(
          filename = fileWithPath,
          plot = plotGenerated
        )
      )

      testthat::expect_snapshot_file(fileWithPath)
    }
  }

  # .vs.cov family
  for (prefixFunc in c("nlme.par", "nlme.ranpar", "nlme.var")) {
    fileName <- paste(.Platform$OS.type, prefixFunc, "vs.cov", sep = ".")
    fileWithPath <- file.path(TempDir, paste(fileName, ext, sep = "."))
    if (file.exists(fileWithPath)) {
      file.remove(fileWithPath)
    }

    suppressWarnings(plotGenerated <-
      do.call(
        what = paste0(prefixFunc, ".vs.cov"),
        args = list(
          xpdb = xpdb,
          nrow = 2,
          ncol = 2
        )
      ))

    suppressWarnings(
      ggplot2::ggsave(
        filename = fileWithPath,
        plot = plotGenerated[[1]]
      )
    )

    testthat::expect_snapshot_file(fileWithPath)
  }

  # nlme.cov.splom
  fileName <- paste(.Platform$OS.type, "nlme.cov.splom", sep = ".")
  fileWithPath <- file.path(TempDir, paste(fileName, ext, sep = "."))
  if (file.exists(fileWithPath)) {
    file.remove(fileWithPath)
  }

  suppressWarnings(plotGenerated <-
    do.call(
      what = "nlme.cov.splom",
      args = list(xpdb = xpdb)
    ))

  suppressWarnings(
    ggplot2::ggsave(
      filename = fileWithPath,
      plot = plotGenerated
    )
  )

  testthat::expect_snapshot_file(fileWithPath)
})
