% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chile_unemployment.R
\name{get_chile_unemployment}
\alias{get_chile_unemployment}
\title{Get Chile's Unemployment Rate (Total) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SL.UEM.TOTL.ZS}
}
\usage{
get_chile_unemployment()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Unemployment, total (% of total labor force)")
  \item \code{country}: Country name ("Chile")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Unemployment rate as a numeric value (percentage)
}
}
\description{
Retrieves Chile's total unemployment rate, measured as a percentage of the total labor force,
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SL.UEM.TOTL.ZS}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_chile_unemployment()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
