\name{nntsmanifoldnewtonestimationgradientstop}
\alias{nntsmanifoldnewtonestimationgradientstop}
\title{Parameter estimation for NNTS distributions with gradient stop}
\description{Computes the maximum likelihood estimates of the NNTS parameters of an NNTS distribution, using a Newton algorithm on the hypersphere and considering a maximum number of iterations determined by a constraint in
terms of the norm of the gradient}
\usage{nntsmanifoldnewtonestimationgradientstop(data, M = 0, iter = 1000,
initialpoint = FALSE, cinitial,gradientstop=1e-10)}

\arguments{
  \item{data}{Vector of angles in radians}
  \item{M}{Number of components in the NNTS symmetric density}
  \item{iter}{Number of iterations}
  \item{initialpoint}{TRUE if an initial point for the optimization algorithm for the general (asymmetric) NNTS density will be used}
  \item{cinitial}{Vector of size M+1. The first element is real and the next M elements are complex (values for $c_0$ and $c_1, ...,c_M$). The sum of the squared moduli of the parameters must be equal to 1/(2*pi). This is the vector of parameters for the general (asymmetric) NNTS density}gradientstop
  \item{gradientstop}{The minimum value of the norm of the gradient to stop the Newton algorithm on the hypersphere}
}

\value{
  \item{cestimates}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the NNTS model}
  \item{loglik}{Optimum log-likelihood value for the NNTS model}
  \item{AIC}{Value of Akaike's Information Criterion}
  \item{BIC}{Value of Bayesian Information Criterion}
  \item{gradnormerror}{Gradient error after the last iteration}
}
\references{
Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME]
(available at https://arxiv.org/abs/2412.19501)
}
\author{Juan Jose Fernandez-Duran y Maria Mercedes Gregorio-Dominguez}

\examples{

data(Turtles_radians)
resturtles<-nntsmanifoldnewtonestimationgradientstop(data=Turtles_radians, M = 2,
iter=1000,gradientstop=1e-10)
resturtles
}
