\name{samplecircularskewness}
\alias{samplecircularskewness}
\title{Calculation of the Sample Skewness}
\description{Computes the skewness for a sample of angles}
\usage{samplecircularskewness(data)}
\arguments{
  \item{data}{Vector of angles in radians}
}
\value{
  \item{Value}{Value of the sample skewness}
}
\references{
Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME]
(available at https://arxiv.org/abs/2412.19501)
}
\author{Juan Jose Fernandez-Duran y Maria Mercedes Gregorio-Dominguez}

\examples{
data(Ants_radians)
samplecircularskewness(data=Ants_radians)

# non-symmetric
cp3a<-c(0.27672975+0.00000000i,-0.04547516-0.00298663i,-0.18680096-0.10457410i,
0.03339396-0.18317526i)
cp3a<-cp3a/sqrt(sum(Mod(cp3a)^2))
cp3a<-(1/sqrt(2*pi))*cp3a

cp3annts<-cbind(c(0,1,2,3),cp3a)
nntsmeasureslocationdispersion(cp3annts,M=3)
set.seed(1234567890)
datasim3a<-nntssimulation(1000,cp3a,3)$simulations
samplecircularskewness(datasim3a)

#symmetric
cp3b<-Mod(cp3a)
cp3bnnts<-cbind(c(0,1,2,3),cp3b)
nntsmeasureslocationdispersion(cp3bnnts,M=3)
set.seed(1234567890)
datasim3b<-nntssimulation(1000,cp3b,3)$simulations
samplecircularskewness(datasim3b)

#symmetric bis
cp3c<-c(0.3131489,0.1421822,0.1266749,0.1575766)
cp3c<-cp3c/sqrt(sum(Mod(cp3c)^2))
cp3c<-(1/sqrt(2*pi))*cp3c
cp3c<-cp3c*exp((0:3)*1i*(-pi))
cp3cnnts<-cbind(c(0,1,2,3),cp3c)
nntsmeasureslocationdispersion(cp3cnnts,M=3)
set.seed(1234567890)
datasim3c<-nntssimulation(1000,cp3c,3)$simulations
samplecircularskewness(datasim3c)

}
