#' @title Calculating Silhouette on Linear Data Clusters
#'
#' @description
#' A fast linear-time algorithm to calculate silhouette information on
#' one-dimensional data with cluster labels.
#'
#' @param x a numeric vector of one-dimensional points
#' @param cluster an integer vector of cluster labels for each point
#'
#' @details The silhouette information on one-dimensional data is
#' calculated in linear time here, instead of quadratic time by
#' definition. There is an overhead of sorting \eqn{O(n \log n)}{O(n log n)} if the
#' input data are not sorted.
#'
#'
#' @return The function returns a numeric value of the average
#'  silhouette information calculated on the input data clusters.
#'
#' @examples
#' x <- c(-1.2, -2, -3, -2.5, 1, 0.8, 1.5, 1.2)
#' cluster <- c(1, 1, 1, 1, 2, 2, 2, 2)
#' fast.sil(x, cluster)
#'
#'
#' @export
fast.sil <- function(x, cluster) {
  return(linearsil(x, cluster))
}
