% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.taxonGroups.r
\name{print.taxonGroups}
\alias{print.taxonGroups}
\title{Compact display of taxon groups}
\usage{
\method{print}{taxonGroups}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"taxonGroups"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Nothing is directly returned, instead a text summary describing a \code{"taxonGroups"} object is printed to the console.
}
\description{
Displays a compact summary of a taxonGroups object.
}
\details{
Displays some basic summary information on a taxon groups object, including number of groups and their names and partial contents.
}
\examples{

# Create a taxon groups object:
taxon_groups <- list(
  Group_A = c("Species_1", "Species_2", "Species_3"),
  Group_B = c("Species_3", "Species_4"),
  Group_C = c("Species_5", "Species_6", "Species_7", "Species_8")
)

# Set class as taxonGroups:
class(taxon_groups) <- "taxonGroups"

# Show print.taxonGroups version of each included data sets:
print.taxonGroups(x = taxon_groups)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
