% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problemdata.R
\name{problemdata}
\alias{problemdata}
\title{Claims problem data}
\usage{
problemdata(E, d, draw = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{draw}{A logical value.}
}
\value{
The minimal rights vector; the truncated claims vector; the sum, the half-sum of the claims, and the class (lower-half, higher-half, and midpoint domains) to which the claims problem belongs. It returns \code{cod  = 1} if the claims problem belong to the lower-half domain, \code{cod  =  -1}  if it belongs to the higher-half domain, and \code{cod = 0}  for the midpoint domain.  Moreover, if  \code{draw = TRUE} a plot of the claims, from small to large in the interval [0,D], is given.
}
\description{
The function returns which of the following subdomains the claims problem belongs to:  the lower-half, higher-half, and  midpoint domains. In addittion, the function returns
the minimal rights vector, the truncated claims vector, the sum and the half-sum of claims.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{D=\sum_{i \in N} d_i\ge E}.

The lower-half domain is the subdomain of claims problems for which the endowment is less or equal than the half-sum of claims, \eqn{E \le  D/2}.

The higher-half domain is the subdomain of claims problems for which the endowment is greater or equal than the half-sum of claims, \eqn{E \ge  D/2}.

The midpoint domain is the subdomain of claims problems for which the endowment is equal to the half-sum of claims, \eqn{E =  D/2}.

The minimal right of claimant \eqn{i\in N} in \eqn{(E,d)} is whatever is left after every other claimant has received his claim, or 0 if that is not possible:
\deqn{m_i(E,d)=\max\{0,E-d(N\backslash\{i\})\}.}
Let \eqn{m(E,d)=\Bigl(m_1(E,d),\dots,m_n(E,d)\Bigr)} be the vector of minimal rights.

The truncated claim of claimant \eqn{i\in N} in \eqn{(E,d)} is the minimum of the claim and the endowment:
\deqn{t_i(E,d)=\min\{d_i,E\}.}
Let \eqn{t(E,d)=\Bigl(t_1(E,d),\dots,t_n(E,d)\Bigr)} be the vector of truncated claims.
}
\examples{
E=10
d=c(2,4,7,8)
problemdata(E,d,draw=TRUE)
}
\seealso{
\link{allrules}, \link{setofawards}.
}
