% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedrules.R
\name{schedrules}
\alias{schedrules}
\title{Schedules of awards of several rules}
\usage{
schedrules(d, claimant, Rules, col = NULL, points = 201, legend = TRUE)
}
\arguments{
\item{d}{A vector of claims.}

\item{claimant}{A claimant.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{col}{The colours. If \code{col = NULL} then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink", "orange", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{points}{The number of endowment values to draw the path.}

\item{legend}{A logical value. The colour legend is shown if \code{legend = TRUE}.}
}
\value{
The graphical representation of the schedules of awards of the rules for the claims vector and the same claimant.
}
\description{
This function returns the graphical representation of the schedules of awards of different rules for a claims vector and a given claimant.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{d\in \mathbb{R}_+^N} a vector of claims and
 denote by  \eqn{D=\sum_{i\in N} d_i} the sum of the claims.

The schedules of awards of a rule \eqn{\mathcal{R}} for claimant \eqn{i} is the function \eqn{S} that assigns to each \eqn{E\in [0,D]} the  value:
\eqn{S(E)=\mathcal{R}_i(E,d)\in \mathbb{R}}.
Therefore, the schedules of awards of a rule plots each claimants's award as a function of \eqn{E}.
}
\examples{
d=c(2,4,7,8)
claimant=2
Rules=c(Talmud,RA,AA)
col=c("red","green","blue")
schedrules(d,claimant,Rules,col)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{pathawards}, \link{pathawards3}, \link{schedrule}, \link{verticalruleplot}.
}
