% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{aci}
\alias{aci}
\title{Atmospheric Clarity Index}
\usage{
aci(data, toa, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{net radiation, J/m2}

\item{toa}{solar radiation at TOA, W/m2}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
index value
}
\description{
Ratio between solar radiation at surface and solar radiation at TOA (alt top of the atmosphere)
}
\examples{
data(data_all)
aci(data = data_all$radiation, toa = data_all$radiationtoa)
}
