% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{mfi}
\alias{mfi}
\title{Modified Fournier Index}
\usage{
mfi(data, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{daily precipitation, mm}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{further arguments passed to or from other methods}
}
\value{
index value
}
\description{
The precipitation concentration index is frequently associated to erosion risk.  Values: 0-60 very low; 60-90 Low; 90-120 moderate; 120-160 high; > 160 very high.
}
\section{Formula}{
 \deqn{MFI = \sum_{i=1}^{12} \frac{P_i ^ 2} {P_t}}
}

\examples{
data(data_all)
mfi(data = data_all$rr)
}
\references{
Fournier F. 1960. Climat et Erosion. PUF: Paris. Arnoldus HM. 1980. An approximation of the rainfall factor in the Uni-versal Soil Loss Equation. In Assessments of Erosion, de Boodts M,Gabriels D (eds). John Wiley and Sons Ltd, Chichester 127–132. De Luis M., González-Hidalgo J.C., Longares L.A. Is rainfal erosivity increasing in the Mediterranean Iberian Peninsula?. Land Degradation & Development, 21: 139-144.
}
