% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ILE}
\alias{ILE}
\title{ILE: Structure of the Isoleucine}
\format{
This list contains the following components:
\describe{
  \item{\code{phi}}{main chain torsion angle for atoms C,N,CA,C.}
  \item{\code{psi}}{main chain torsion angle for atoms N,CA,C,N.}
  \item{\code{chi1}}{side chain torsion angle for atoms N,CA,CB,*G.}
  \item{\code{chi2}}{side chain torsion angle for atoms CA,CB,*G,*D.}
}
}
\source{
This data is extracted from PISCES server \url{http://dunbrack.fccc.edu/pisces/}
}
\usage{
ILE
}
\description{
An isomer of leucine, essential branched-chain aliphatic amino acid found in many proteins.
}
\details{
ILE data is generated with collection of different pdb files. To select adequate protein
  data, we use PISCES server. (the method is introduced in articles of references.)
  To select high-quality protein data, we use several benchmarks:
  resolution : 1.6A(angstrom) or better,
  R-factor : 0.22 or better,
  Sequence percentage identity: <= 25%.
  Then, we select ILE only angular data for each protein data. To see the detail code, visit
  \url{https://github.com/sungkyujung/ClusTorus}
}
\references{
Data description is from \url{https://www.rcsb.org/ligand/ILE}.

  The data extracting method is from Harder, T., Boomsma, W., Paluszewski, M., Frellsen, J., Johansson, K. E., & Hamelryck, T. (2010). Beyond rotamers: a generative, probabilistic model of side chains in proteins. \emph{BMC bioinformatics}, 11(1), 1-13.

  Mardia, K. V., Kent, J. T., Zhang, Z., Taylor, C. C., & Hamelryck, T. (2012). Mixtures of concentrated multivariate sine distributions with applications to bioinformatics. \emph{Journal of Applied Statistics}, 39(11), 2475-2492.
}
\seealso{
Description of the angluar information is from the 'value'
  part of \code{torsion.pdb} in the package \code{bio3d}.
}
\keyword{datasets}
