% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-utils.R
\name{calculate_markers_shiny}
\alias{calculate_markers_shiny}
\title{Calculate markers - Shiny}
\usage{
calculate_markers_shiny(
  cells1,
  cells2,
  logfc_threshold = 0,
  min_pct_threshold = 0.1,
  average_expression_threshold = 0,
  average_expression_group1_threshold = 0,
  min_diff_pct_threshold = -Inf,
  used_slot = "data",
  norm_method = "SCT",
  expression_h5_path = "expression.h5",
  pseudocount_use = 1,
  base = 2,
  verbose = TRUE,
  check_difference = TRUE
)
}
\arguments{
\item{cells1}{A vector of cell indices for the first group of cells.}

\item{cells2}{A vector of cell indices for the second group of cells.}

\item{logfc_threshold}{The minimum absolute log fold change to consider a
gene as differentially expressed. Defaults to \code{0}, meaning all genes are
taken into considereation.}

\item{min_pct_threshold}{The minimum fraction of cells expressing a gene
form each cell population to consider the gene as differentially expressed.
Increasing the value will speed up the function. Defaults to \code{0.1}.}

\item{average_expression_threshold}{The minimum average expression that a
gene should have in order to be considered as differentially expressed.}

\item{average_expression_group1_threshold}{The minimum average expression
that a gene should have in the first group of cells to be considered as
differentially expressed. Defaults to \code{0}.}

\item{min_diff_pct_threshold}{The minimum difference in the fraction of cells
expressing a gene between the two cell populations to consider the gene as
differentially expressed. Defaults to \code{-Inf}.}

\item{used_slot}{Parameter that provides additional information about the
expression matrix, whether it was scaled or not. The value of this parameter
impacts the calculation of the fold change. If \code{data}, the function will
calculates the fold change as the fraction between the log value of the
average of the expression raised to exponential for the two cell groups. If
\code{scale.data}, the function will calculate the fold change as the fraction
between the average of the expression values for the two cell groups.
Other options will default to calculating the fold change as the fraction
between the log value of the average of the expression values for the two
cell groups. Defaults to \code{data}.}

\item{norm_method}{The normalization method used to normalize the expression
matrix. The value of this parameter impacts the calculation of the average
expression of the genes when \code{used_slot = "data"}. If \code{LogNormalize}, the
log fold change will be calculated as described for the \code{used_slot}
parameter. Otherwise, the log fold change will be calculated as the fraction
between the log value of the average of the expression values for the two
cell groups. Defaults to \code{SCT}.}

\item{expression_h5_path}{The path to the h5 file containing the expression
matrix. The h5 file should contain the following fields: \code{expression_matrix},
\code{rank_matrix}, \code{average_expression}, \code{genes}. The file path
defaults to \code{expression.h5}.}

\item{pseudocount_use}{The pseudocount to add to the expression values when
calculating the average expression of the genes, to avoid the 0 value for
the denominator. Defaults to \code{1}.}

\item{base}{The base of the logharithm. Defaults to \code{2}.}

\item{verbose}{Whether to print messages about the progress of the function.
Defaults to TRUE.}

\item{check_difference}{Whether to perform set difference between the two
cells. Defaults to TRUE.}
}
\value{
A data frame containing the following columns:
\itemize{
\item \code{gene}: The gene name.
\item \code{avg_log2FC}: The average log fold change between the two cell groups.
\item \code{p_val}: The p-value of the Wilcoxon rank sum test.
\item \code{p_val_adj}: The adjusted p-value of the Wilcoxon rank sum test.
\item \code{pct.1}: The fraction of cells expressing the gene in the first cell group.
\item \code{pct.2}: The fraction of cells expressing the gene in the second cell group.
\item \code{avg_expr_group1}: The average expression of the gene in the first cell group.
\item \code{avg_expr}: The average expression of the gene.
}
}
\description{
Performs the Wilcoxon rank sum test to identify differentially
expressed genes between two groups of cells in the shiny context. The
method can be also used outside the shiny context, as long as the expression
matrix is stored in a h5 file.
}
