% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{evaluate_best_validation_external_by_metrics}
\alias{evaluate_best_validation_external_by_metrics}
\title{Evaluates algorithms by measures of dissimilarity based on a metric.}
\usage{
evaluate_best_validation_external_by_metrics(df, metric)
}
\arguments{
\item{df}{Data matrix or data frame with the result of running the clustering
algorithm.}

\item{metric}{String with the metric.}
}
\value{
A data.frame with the algorithms classified by measures of
dissimilarity.
}
\description{
Method that calculates which algorithm and which metric behaves
best for the datasets provided.
}
\details{
Method groups the data by algorithm and distance measure, instead
of obtaining the best attribute from the data set.
}
\examples{

result = Clustering::clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='kmeans_rcpp',
               metrics=c("F_measure"))

Clustering::evaluate_best_validation_external_by_metrics(result,'F_measure')

}
