% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRF.r
\name{generateRF}
\alias{generateRF}
\title{Simulation of random field with given marginals and spatiotemporal properties}
\usage{
generateRF(n, STmodel)
}
\arguments{
\item{n}{number of fields (time steps) to simulate}

\item{STmodel}{list of arguments resulting from \code{\link{fitVAR}} function}
}
\description{
Generates random field with given marginals and spatiotemporal properties,
just provide (1) the output of \code{\link{fitVAR}} function, and (2) the number of time
steps to simulate.
}
\details{
Referring to the documentation of \code{\link{fitVAR}} for details on
computational complexity of the fitting algorithm, here we report indicative
simulation CPU times for some settings, assuming that the model parameters are
already evaluated. CPU times refer to a Windows 10 Pro x64 laptop with
Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz, 4-core, 8 logical processors, and 32GB RAM. \cr
CPU time:\cr
m = 30, p = 1, n = 1000: ~17s \cr
m = 30, p = 1, n = 10000: ~75s \cr
m = 30, p = 5, n = 100: ~280s \cr
m = 30, p = 5, n = 1000: ~302s \cr
m = 50, p = 1, n = 1000 : ~160s \cr
m = 50, p = 1, n = 10000 : ~570s
where m denotes the side length of a square field (mxm)
}
\examples{
## The example below refers to the simulation of few random fields of
## size 10x10 with AR(1) temporal correlation for the sake of illustration.
## For a more effective visualization and reliable performance assessment,
## we suggest to generate a larger number of fields (e.g. 100 or more)
## of size about 30X30.
## See section 'Details' for additional information on running times
## with different settings.

fit <- fitVAR(
  spacepoints = 10,
  p = 1,
  margdist ='burrXII',
  margarg = list(scale = 3, shape1 = .9, shape2 = .2),
  p0 = 0.8,
  stcsid = "clayton",
  stcsarg = list(scfid = "weibull", tcfid = "weibull",
                 copulaarg = 2,
                 scfarg = list(scale = 20, shape = 0.7),
                tcfarg = list(scale = 1.1, shape = 0.8))
)

sim <- generateRF(n = 12,
                    STmodel = fit)
checkRF(sim,
          lags = 10,
          nfields = 12)

}
