% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortTiming.R
\name{plotCohortTiming}
\alias{plotCohortTiming}
\title{Plot summariseCohortTiming results.}
\usage{
plotCohortTiming(
  result,
  plotType = "boxplot",
  timeScale = "days",
  uniqueCombinations = TRUE,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator"),
  style = "default"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{plotType}{Type of desired formatted table, possibilities are "boxplot" and
"densityplot".}

\item{timeScale}{Time scale to show, it can be "days" or "years".}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Named list that specifies how to style the different parts of
the table generated. It can either be a pre-defined style ("default" or
"darwin" - the latter just for gt and flextable), NULL to get the table
default style, or custom. Keep in mind that styling code is different for
all table styles. To see the different styles see \code{visOmopResults::tableStyle()}.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
library(DrugUtilisation)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  name = "my_cohort",
  ingredient = c("acetaminophen", "morphine", "warfarin")
)

timings <- summariseCohortTiming(cdm$my_cohort)

plotCohortTiming(
  timings,
  timeScale = "years",
  uniqueCombinations = FALSE,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator")
)

plotCohortTiming(
  timings,
  plotType = "densityplot",
  timeScale = "years",
  uniqueCombinations = FALSE,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator")
)

cdmDisconnect(cdm = cdm)
}

}
