% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harmonization.R
\name{covfam}
\alias{covfam}
\title{CovBat Family Harmonization}
\usage{
covfam(
  data,
  bat,
  covar = NULL,
  model = lm,
  formula = NULL,
  score.model = NULL,
  score.args = NULL,
  eb = TRUE,
  robust.LS = FALSE,
  ref.batch = NULL,
  percent.var = 0.95,
  n.pc = NULL,
  std.var = TRUE,
  ...
)
}
\arguments{
\item{data}{\emph{n x p} data frame or matrix of observations where
\emph{p} is the number of features and \emph{n} is the number of subjects.}

\item{bat}{Factor indicating batch (often equivalent to site or scanner)}

\item{covar}{Data frame or matrix of covariates supplied to \code{model}}

\item{model}{Model function. ComBat Family supports any models that take
arguments \code{formula} and \code{data}, but are limited to models fitting with
identity link (e.g. \code{family = gaussian(link = "identity")}). This includes
\link[stats]{lm}, \link[mgcv]{gam}, \link[gamlss]{gamlss},
\link[quantreg]{rq}, \link[lme4]{lmer}, and more}

\item{formula}{Formula for \code{model} starting with \verb{y ~} where \code{y} represents
each feature}

\item{score.model}{Model for scores, defaults to NULL for fitting basic
location and scale model without covariates on the scores}

\item{score.args}{List of arguments for score model}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for mean
and variance harmonization.}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators
for error variance and site effect parameters. Uses median and
biweight midvariance}

\item{ref.batch}{Reference batch, must take value in \code{levels(bat)}}

\item{percent.var}{Numeric. The number of harmonized principal component
scores is selected to explain this proportion of the variance}

\item{n.pc}{Optional numeric. If specified, this number of principal
component scores is harmonized. Overrides \code{percent.var}}

\item{std.var}{If \code{TRUE}, scales variances to be equal to 1 before PCA.}

\item{...}{Additional arguments to \code{model}}
}
\value{
\code{covfam} returns a list containing the following components:
\item{dat.covbat}{Harmonized data as a matrix with same dimensions as \code{data}}
\item{batch.info}{Batch information, including reference batch if specified}
\item{combat.out}{List output of \code{comfam} from the ComBat step}
\item{pc.output}{Output of \code{prcomp} from PCA step}
\item{n.pc}{Numeric, number of PCs harmonized}
\item{scores.com}{List output of \code{comfam} from the CovBat step}
}
\description{
Implementation of the CovBat Family of harmonization methods allowing for
removal of multivariate batch effects, flexible covariate modeling and
alternative estimators for site effect adjustment. Support for modeling of
both location and scale via GAMLSS. Additional support for modeling of
covariate effects in score location and scale.
}
\examples{
covfam(iris[,1:2], iris$Species)
covfam(iris[,1:2], iris$Species, iris[3:4], lm, y ~ Petal.Length + Petal.Width)
}
