% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_matrix_to_df.R
\name{subset_matrix_to_df}
\alias{subset_matrix_to_df}
\title{Convert matrices to list of data frames for subnetworks}
\usage{
subset_matrix_to_df(func_matrix, str_matrix)
}
\arguments{
\item{func_matrix}{a square, symmetric matrix to be used as the main input for
the \code{\link{hms}} algorithm. For brain connectivity, this will be a
representation of functional (e.g., BOLD) connectivity.}

\item{str_matrix}{a square, symmetric matrix to be used as the guidance input
for the \code{\link{hms}} algorithm. For brain connectivity, this will be a
representation of structural (e.g., white matter) connectivity.}
}
\value{
A list of data frame containing the functional matrix,
structural matrix, a data frame of the functional edge weights, a data frame
of the structural edge weights, and nodal information (functional degree,
structural degree, community assignment, and label information)
}
\description{
Description of the convert matrices to data frame list for subnetworks function.
}
\details{
This is an ancillary function that creates a data frame list for the
subnetworks created using the multimodal hierarchical spinglass algorithm.
}
