% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomppareto.R
\name{dwdcomppareto}
\alias{dwdcomppareto}
\title{The probability mass function (pmf) of a discrete composite distribution with Pareto tail}
\usage{
dwdcomppareto(x, spec, alpha, theta, log = FALSE, ...)
}
\arguments{
\item{x}{A scalar or vector of nonnegative integer values at which the probability mass needs to be evaluated}

\item{spec}{The selection of the lower tail (head) distribution}

\item{alpha}{The shape parameter of the Pareto distribution}

\item{theta}{The scale parameter of Pareto, also serve as the location parameter of the composite model}

\item{log}{logical; if TRUE, probability p are given as log(p)}

\item{...}{The parameter of the lower tail (head) distribution}
}
\value{
an object of the same length of x as the probability mass evaluated at x
}
\description{
\code{dwdcomppareto} returns the pmf of a discrete composite distribution with a Pareto upper tail at a point x, with a specified distribution at the lower tail.
}
\examples{
x<-1:100
dwdcomppareto(x, "lnorm", 0.4, 1, meanlog = 1, sdlog = 0.8)
dwdcomppareto(x, "weibull", alpha = 1.5, theta = 1.5, shape = 2, scale = 2)
}
