% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomppareto.R
\name{pwdcomppareto}
\alias{pwdcomppareto}
\title{The cumulative distribution function (CDF) of a discrete composite distribution with Pareto tail}
\usage{
pwdcomppareto(x, spec, alpha, theta, log.p = FALSE, ...)
}
\arguments{
\item{x}{A scalar or vector of positive values at which the CDF needs to be evaluated}

\item{spec}{The selection of the lower tail (head) distribution}

\item{alpha}{The shape parameter of the Pareto distribution}

\item{theta}{The scale parameter of Pareto, also serve as the location parameter of the composite model}

\item{log.p}{logical; if TRUE, probability p are given as log(p)}

\item{...}{The parameter of the lower tail (head) distribution}
}
\value{
an object of the same length of x as the CDF evaluated at x
}
\description{
\code{pwdcomppareto} returns the CDF of a discrete composite distribution with a Pareto upper tail at x, with a specified distribution at the lower tail.
}
\examples{
x<-1:100
pwdcomppareto(x, "lnorm", 0.4, 1, meanlog = 1, sdlog = 0.8)
pwdcomppareto(x, "weibull", alpha = 1.5, theta = 1.5, shape = 2, scale = 2)
}
