% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredLGR.R
\name{PredLGR}
\alias{PredLGR}
\title{Prediction of compound event occurrences}
\usage{
PredLGR(Y,CI,CI0)
}
\arguments{
\item{Y}{Occurrences of compound dry-hot events (0-1 binary variable) (L lead time)}

\item{CI}{Climate index (CI) as the driving factor of compound events (e.g., ENSO)}

\item{CI0}{Specified CI value based on which the prediction is issued}
}
\value{
Probability of occurrences estimated at CI0
}
\description{
Fit the logistic regression model (LGR) based on occurrences of compound events (Y) and climate index (CI).The output is the predicted probability of compound event occurrence for the given climate index value CI0
}
\examples{
CI=c(-0.7,-1.2,1.3,0.7,-0.6,1.1,-0.5,0.8,0.5,-0.5,1.6,-1.8,-0.5,-1.4,-0.1,2.2,-0.7,-1.1, 0.6, -1.7)
Y=c(0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0 )
PredLGR(Y,CI,2)
}
\references{
Hao, Z. et al. (2019). Statistical prediction of the severity of compound dry-hot events based on ENSO . J. Hydrol., 572: 243-250.
}
