% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prod_optim.R
\name{prod_optim}
\alias{prod_optim}
\title{prod_optim}
\usage{
prod_optim(
  X,
  height,
  DS,
  D0 = NA,
  C0,
  pmap,
  cmap,
  conc,
  dstor = 0,
  zero_flux = TRUE,
  F0 = 0,
  known_flux = NA,
  known_flux_factor = 0,
  DSD0_optim = FALSE,
  layer_couple,
  wmap,
  evenness_factor
)
}
\arguments{
\item{X}{(numeric vector) specifying the production rates to be optimized}

\item{height}{(numeric vector) giving the height of each step}

\item{DS}{(numeric vector) giving the DS of each step}

\item{D0}{RESERVED FOR FUTURE EXPANSION}

\item{C0}{(numeric) The concentration at the
bottom of the lowermost step.}

\item{pmap}{(integer vector) assigning a production from X to each step}

\item{cmap}{(integer vector) assigning the modeled concentrations to the
observed concentrations as there can be multiple observations per depth}

\item{conc}{(numeric) the observed concentrations (in the same unit as
the modelled concentrations).}

\item{dstor}{RESERVED FOR FUTURE EXPANSION}

\item{zero_flux}{(logical) Applies the zero-flux boundary
condition(\code{TRUE})? If \code{FALSE}, the first value in \code{X}.
represents the incoming flux to the lowest layer.}

\item{F0}{(numeric) flux into lowest layer.}

\item{known_flux}{RESERVED FOR FUTURE EXPANSION}

\item{known_flux_factor}{RESERVED FOR FUTURE EXPANSION}

\item{DSD0_optim}{RESERVED FOR FUTURE EXPANSION}

\item{layer_couple}{(numeric vector) A vector defining the weights that bind
the different layers together. If all is zero, no penalisation for stark
differences between the optimized production rates of adjacent layers takes
place}

\item{wmap}{(numeric) A vector defining the weights of the different
concentration measurements in the RMSE calculation.}

\item{evenness_factor}{(numeric) Defines strong should stark differences
between the production rates and very small production rates be penalized.}
}
\value{
A modified RMSE root mean square error of the modeled and measured
concentration.
}
\description{
This is the optimizer-function that is
minimized for the inverse, production based model.
It takes as input a vector of the influx, as well as the
values of the production to be optimized.

This function is embedded in \code{\link[=pro_flux]{pro_flux()}} and is not intended to be
used manually.
}
\examples{
\donttest{
prod_optim(c(1,1,1),
 c(0.1,0.1,0.1),
 DS = D0_massman("CO2", 10, 1013),
 C0 = c(42*2000/1000/1000),
 conc = c(400, 1000, 2000)*42/1000/1000,
 wmap = 1,
 layer_couple = 1,
 evenness_factor = 1)
 }

}
\seealso{
Other proflux: 
\code{\link{prod_mod_conc}()}
}
\concept{proflux}
\keyword{internal}
