% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCoolingPower.R
\name{calcCoolingPower}
\alias{calcCoolingPower}
\title{Calculate Cooling Power}
\usage{
calcCoolingPower(Temp1, Temp2, RH1, RH2, volumeFlowRate)
}
\arguments{
\item{Temp1}{Initial Temperature (°Celsius)}

\item{Temp2}{Final Temperature (°Celsius)}

\item{RH1}{Initial Relative Humidity (0-100\%)}

\item{RH2}{Final Relative Humidity (0-100\%)}

\item{volumeFlowRate}{Volume flow rate of air (m³/s)}
}
\value{
Cooling power in kilowatts (kW)
}
\description{
This function calculates the cooling power based on initial and final air
conditions and volume flow rate.

Cooling power is the rate of energy transferred during a cooling process.
}
\examples{
calcCoolingPower(30, 22, 70, 55, 0.8)

calcCoolingPower(Temp1 = 25, Temp2 = 20, RH1 = 70, RH2 = 50, volumeFlowRate = 0.5)




}
\references{
ASHRAE Handbook Fundamentals
}
\seealso{
\code{\link{calcEnthalpy}}, \code{\link{calcAD}}
}
