% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSensibleHeatRatio.R
\name{calcSensibleHeatRatio}
\alias{calcSensibleHeatRatio}
\title{Calculate Sensible Heat Ratio (SHR)}
\usage{
calcSensibleHeatRatio(Temp1, Temp2, RH1, RH2, volumeFlowRate)
}
\arguments{
\item{Temp1}{Initial Temperature (°Celsius)}

\item{Temp2}{Final Temperature (°Celsius)}

\item{RH1}{Initial Relative Humidity (0-100\%)}

\item{RH2}{Final Relative Humidity (0-100\%)}

\item{volumeFlowRate}{Volume flow rate of air in cubic meters per second (m³/s)}
}
\value{
SHR Sensible Heat Ratio (0-100\%)
}
\description{
This function calculates the Sensible Heat Ratio (SHR) using the sensible and total heating values.

Sensible heat ratio is the ratio of sensible heat to total heat.
}
\examples{
calcSensibleHeatRatio(20, 25, 50, 30, 0.5)


}
\seealso{
\code{\link{calcSensibleHeating}}, \code{\link{calcTotalHeating}}
}
