% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kunfolding.R
\name{kunfolding}
\alias{kunfolding}
\title{Kemeny-equivalent augmented unfolding}
\usage{
kunfolding(X, p = 2, control = mdscontrol(...), ...)
}
\arguments{
\item{X}{A n by m data matrix, in which there are n judges and m objects to be judged. Each row is a ranking of the objects which are represented by the columns.}

\item{p}{the dimensionality of the solution. Default p=2}

\item{control}{a list of options that control details of the \code{kunfolding} model governed by the function
\code{mdscontrol}. The options govern the MDS model ("ordinal" or "metric"), 
the initial configuration ("torgerson", "random" or "user"), the transformation ("primary", "secondary", "tertiary","spline","ratio",
"interval","none"), the set of weights, and other related options}

\item{\dots}{arguments passed bypassing \code{mdscontrol}}
}
\value{
An object of the class kunfolding. See details for detailed information.
}
\description{
Kemeny-equivalent augmented unfolding.
}
\details{
The MDS engine is smacofsym from \code{smacof}.In a future release other mds algorithms will be implemented. 
The output consists in a object of the class "kunfolding". It contains:
\tabular{llll}{
rawstress \tab \tab \tab raw stress\cr
nrawstress\tab \tab  \tab normalized raw stress\cr
stress1 \tab  \tab \tab Stress-1\cr
rowcoord \tab \tab \tab row (individuals) coordinates\cr
colcord \tab \tab \tab column (items) coordinates\cr
dhat \tab \tab \tab dhat\cr
dij\tab \tab \tab configuration distance\cr
shepardD \tab \tab \tab DeSarbo I Index \cr
kendallfit \tab  \tab \tab Kendall tau_b between transformed and fitted proximities\cr
tauxfit \tab \tab \tab Tau_X between transformed and fitted proximities\cr
avgrecov \tab \tab \tab Averaged recovery measure between raw preference data and fitted proximities\cr
avgedpearson \tab \tab \tab Averaged Pearson correlation between raw preference data and fitted proximities\cr
avgspearman \tab \tab \tab Averaged Spearman rho between raw preference data and fitted proximities\cr 
avgkendall \tab \tab \tab Averaged Kendall taub between raw preference data and fitted proximities\cr
avgtaux \tab \tab \tab Averaged Tau_X between raw preference data and fitted proximities\cr
resume \tab \tab \tab Resume meausures\cr
resumerec \tab tab \tab Resume of recovery measures\cr
resumeaug \tab \tab \tab Resume of augmentation matrix\cr
kDelta \tab \tab \tab Kemeny equivalent dissimilarity matrix\cr
beta \tab \tab \tab beta parameter\cr
alpha \tab \tab \tab alpha parameter \cr
interactions \tab \tab \tab n x m interaction submatrix \cr
csi \tab \tab \tab csi parameter \cr
mdssol \tab \tab \tab mds solution as returned by \code{smacof} package \cr
n_i \tab \tab \tab number of individuals\cr
n_c \tab \tab \tab number of items \cr
tots \tab \tab \tab total \cr
model \tab \tab \tab mds model \cr
transf \tab \tab \tab transformation used
}
}
\examples{
data("breakfast", package="smacof")
unfout <- kunfolding(breakfast)
itemsl <- colnames(breakfast)
plot(unfout,labs=itemsl)

}
\references{
D'Ambrosio, A., Vera, J. F., & Heiser, W. J. (2022). Avoiding degeneracies in ordinal unfolding using Kemeny-equivalent dissimilarities for two-way two-mode preference rank data. Multivariate Behavioral Research, 57(4), 679-699.
}
\seealso{
\code{augmatrix}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Kemeny-equivalent}
\keyword{Unfolding}
\keyword{augmented}
\keyword{unfolding}
